#include "stdafx.h"
#include "LF C DEMO.h"
#include "DlgReadWrite.h"
#include "LF_ID_C_API.h"

#include "Utility.h"

IMPLEMENT_DYNAMIC(CDlgReadWrite, CPropertyPage)

CDlgReadWrite::CDlgReadWrite()
	: CPropertyPage(CDlgReadWrite::IDD)
{

}

CDlgReadWrite::~CDlgReadWrite()
{
}

void CDlgReadWrite::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_OFFSET, m_ctrlOffset);
	DDX_Control(pDX, IDC_EDIT_NRBYTES, m_ctrlNrBytes);
	DDX_Control(pDX, IDC_EDIT_DATA, m_ctrlData);
	DDX_Control(pDX, IDC_EDIT_LOGIN, m_ctrlLogin);
}


BEGIN_MESSAGE_MAP(CDlgReadWrite, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_READ, &CDlgReadWrite::OnBnClickedBtnRead)
	ON_BN_CLICKED(IDC_BTN_WRITE, &CDlgReadWrite::OnBnClickedBtnWrite)
END_MESSAGE_MAP()


BOOL CDlgReadWrite::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	m_ctrlOffset.SetWindowText(_T("0"));
	m_ctrlNrBytes.SetWindowText(_T("2"));
	m_ctrlLogin.SetWindowText(_T(""));

	return TRUE;
}

void CDlgReadWrite::OnBnClickedBtnRead()
{
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		CString strTmp = _T("");
		m_ctrlOffset.GetWindowText(strTmp);
		UINT nOffset = _ttoi((LPCTSTR)strTmp);
		m_ctrlNrBytes.GetWindowText(strTmp);
		UINT nNrBytes = _ttoi((LPCTSTR)strTmp);

		EERROR eRet = ER_OK;
		m_ctrlLogin.GetWindowText(strTmp);
		if(strTmp.GetLength() > 0x00)
		{
			USES_CONVERSION;
			BYTE* pData = NULL; UINT nData = 0x00;
			CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strTmp), strTmp.GetLength(), &pData, nData);
			eRet = Login(hReader, pData, nData);
		}

		BYTE pBuf[MAX_PATH]; UINT nSize = MAX_PATH;
		if((eRet == ER_OK) && (ReadData(hReader, nOffset, nNrBytes, pBuf, nSize) == ER_OK))
		{
			m_ctrlData.SetWindowText(CUtility::DataToString(pBuf, nSize, FALSE));
		}

		CloseReader(hReader);
	}
}

void CDlgReadWrite::OnBnClickedBtnWrite()
{
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		CString strTmp = _T("");
		m_ctrlOffset.GetWindowText(strTmp);
		UINT nOffset = _ttoi((LPCTSTR)strTmp);
		m_ctrlNrBytes.GetWindowText(strTmp);
		UINT nNrBytes = _ttoi((LPCTSTR)strTmp);

		EERROR eRet = ER_OK;
		m_ctrlLogin.GetWindowText(strTmp);
		if(strTmp.GetLength() > 0x00)
		{
			ASSERT(strTmp.GetLength() != 0x04);
			USES_CONVERSION;
			BYTE* pData = NULL; UINT nData = 0x00;
			CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strTmp), strTmp.GetLength(), &pData, nData);
			eRet = Login(hReader, pData, nData);
		}

		if(eRet == ER_OK) 
		{
			m_ctrlData.GetWindowText(strTmp);

			USES_CONVERSION;
			BYTE* pData = NULL; UINT nData = 0x00;
			CUtility::HexToByte((BYTE*)T2A((LPCTSTR)strTmp), strTmp.GetLength(), &pData, nData);

			WriteData(hReader, nOffset, nNrBytes, pData, nData);
		}

		CloseReader(hReader);
	}
}
